<?php
namespace App\Models;

use CodeIgniter\Model;

class SuperModel extends Model
{
    protected $table=''; // Default table name
    protected $primaryKey='id';           // Default primary key
    protected $allowedFields='';
    protected $registrationFields = ['id', 'shop_name', 'owner_name', 'dob', 'phone_no', 'alternative_phone_no', 'address', 'city', 'state', 'pincode', 'otp', 'otp_verify', 'status']; // Enable automatic timestamps

    protected $categoriesFields = ['id', 'categoryName']; 

    protected $super_adminFields = ['name','username','password','role'];

    public function tables(string $tableName,String $primaryKey,array $allowedFields){
        $this->table = $tableName;
        $this->primaryKey = $primaryKey;
        $this->allowedFields = $allowedFields;
        return $this;
    }

   public function registrationTable()
   {
       return $this->tables("registration","id",$this->registrationFields);
   }
    public function categoriesTable()
    {
         return $this->tables("categories","id",$this->categoriesFields);
    }

    public function super_admin()
    {
         return $this->tables("super_admin","id",$this->super_adminFields);
    }














}