<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');
$routes->post('register', 'Home::registration');
$routes->post('otpVerify', 'Home::otpVerify');
$routes->post('AddCategories', 'Home::AddCategories');
$routes->post('editCategories', 'Home::editCategories');
$routes->get('showCategories', 'Home::showCategories');
$routes->post('deleteCategories', 'Home::deleteCategories');
$routes->post('fetchSubCategories', 'Home::fetchSubCategories');

$routes->post('addSubCategories', 'Home::addSubCategories');

$routes->post('editSubCategories', 'Home::editSubCategories');

$routes->post('deleteSubCategories', 'Home::deleteSubCategories');

$routes->get('categoriesCount', 'Home::categoriesCount');
$routes->get('subCategoriesCount', 'Home::subCategoriesCount');

$routes->match(['get', 'post'], 'super_admin_login', 'SuperAdmin::login');
$routes->group('admin', function ($routes) {
    $routes->get('shops', 'SuperAdmin::shops');
    $routes->get('shops', 'SuperAdmin::shops');
    $routes->get('action/(:segment)/(:num)', 'SuperAdmin::action/$1/$2');
    $routes->match(['get', 'post'], 'login', 'SuperAdmin::login');
});
